//////////////////////////////////////////////
//	File:		"CMainMenuState.h"
//
//	Author:		Jason Stegner (JS)
//
//	Purpose:	Gives the user a central hub to 
//				access the other states of the game.
//////////////////////////////////////////////

#include "CMainMenuState.h"
#include "CSGD_Direct3D.h"
#include "CSGD_MessageSystem.h"
#include "CSGD_EventSystem.h"
#include "CSGD_FModManager.h"
#include "CSGD_TextureManager.h"
#include "COptionsState.h"
#include "CGame.h"
#include "Messages.h"
#include "CEvent.h"
#include "CGamePlayState.h"
#include "SGD_Math.h"
#include "CBitmapFont.h"

//////////////////////////////////////////
// Function: "GetInstance"
// Purpose:  Returns the instance of the 
//			 CMainMenuState class
//////////////////////////////////////////
CMainMenuState* CMainMenuState::GetInstance()
{
	static CMainMenuState instance;
	return &instance;
}

//////////////////////////////////////////
// Function: "CMainMenuState"
// Purpose:  Constructor
//////////////////////////////////////////
CMainMenuState::CMainMenuState()
{
	// Set all pointers to NULL
	m_pD3D = NULL;
	m_pMS = NULL;
	m_pES = NULL;
	m_pTM = NULL;
	m_pFM = NULL;
	m_pBM = NULL;

	staticImageID1 = 0;
	staticImageID2 = 0;
	staticImageID3 = 0;
	staticImageID4 = 0;

	m_fDelayTime = 0.0f;

	// Set all image IDs to -1
	//m_nImageID = -1;
}

//////////////////////////////////////////
// Function: "~CMainMenuState"
// Purpose:  Destructor
//////////////////////////////////////////
CMainMenuState::~CMainMenuState()
{
}

//////////////////////////////////////////
// Function: "Enter"
// Purpose:  Initializes the class upon
//			 starting to use it
//////////////////////////////////////////
void CMainMenuState::Enter(void)
{
	m_bReset = false;

	// Initialize all pointers to their appropriate singletons
	m_pD3D = CSGD_Direct3D::GetInstance();
	m_pMS = CSGD_MessageSystem::GetInstance();
	m_pES = CSGD_EventSystem::GetInstance();
	m_pFM = CSGD_FModManager::GetInstance();
	m_pTM = CSGD_TextureManager::GetInstance();
	m_pBM = CBitmapFontManager::GetInstance();
	m_pFont = m_pBM->CreateTemplateInstance(m_pBM->LoadTemplate("Resources/menuFont.xml"));
//	m_pFont.LoadKerning("Resources/QuakeShakeKerning.dat");

	// Set image ids
	m_nCursorID = m_pTM->LoadTexture("Resources/Clef_Arrow.png", D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f));
	m_nPlayID = m_pTM->LoadTexture("Resources/Play.png", D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f));
	m_nOptionsID = m_pTM->LoadTexture("Resources/Options.png", D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f));
	m_nLoadID = m_pTM->LoadTexture("Resources/Load.png", D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f));
	m_nExitID = m_pTM->LoadTexture("Resources/Exit.png", D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f));
	//	Set image area.
	m_rImageArea.left = 0;	m_rImageArea.top = 0;	m_rImageArea.right = 749;	m_rImageArea.bottom = 599;
	m_nSelection = -1;

	m_fCursorYPos = 125.0f;

	m_nSelection = 0;

	staticImageID1 = m_pTM->LoadTexture("Resources/Static_1.png");
	staticImageID2 = m_pTM->LoadTexture("Resources/Static_2.png");;
	staticImageID3 = m_pTM->LoadTexture("Resources/Static_3.png");;
	staticImageID4 = m_pTM->LoadTexture("Resources/Static_4.png");;

}

//////////////////////////////////////////
// Function: "Exit"
// Purpose:  Cleans up the class for while
//			 it is not being used
//////////////////////////////////////////
void CMainMenuState::Exit(void)
{

	m_pTM->ReleaseTexture(m_nCursorID);
	m_pTM->ReleaseTexture(m_nPlayID);
	m_pTM->ReleaseTexture(m_nOptionsID);
	m_pTM->ReleaseTexture(m_nLoadID);
	m_pTM->ReleaseTexture(m_nExitID);

	m_pTM->ReleaseTexture(staticImageID1);
	m_pTM->ReleaseTexture(staticImageID2);
	m_pTM->ReleaseTexture(staticImageID3);
	m_pTM->ReleaseTexture(staticImageID4);

	m_nSelection = 0;

	//	Unload assets
	if(m_pD3D)
		m_pD3D = NULL;

	if(m_pMS)
	{
		m_pMS->ShutdownMessageSystem();
		m_pMS = NULL;
	}
	
	if(m_pFM)
		m_pFM = NULL;

	if(m_pTM)
		m_pTM = NULL;

	if(m_pBM)
		m_pBM = NULL;
}

//////////////////////////////////////////
// Function: "Input"
// Purpose:  Handles input for the options
//			 based on time
//////////////////////////////////////////
bool CMainMenuState::Input(float fElapsedTime)
{
	
	// Set up a DirectInput pointer for getting input
	CSGD_DirectInput* pDI = CSGD_DirectInput::GetInstance();

		//	Quit if the user presses ESC
		if (pDI->GetBufferedKey(DIK_ESCAPE))
		{
			// Return false to CGame, signaling an exit
			CGame::GetInstance()->RemoveState();
			return false;
		}

		if(pDI->GetBufferedKey(DIK_RETURN))
		{
			if(m_fCursorYPos == 125.0f)
				m_nSelection = 0;
			else if(m_fCursorYPos == 200.0f)
				m_nSelection = 1;
			else if(m_fCursorYPos == 275.0f)
				m_nSelection = 2;
			else if(m_fCursorYPos == 350.0f)
				m_nSelection = 3;

			//	Depending on the selection, we can do separate actions.
			//	User can toggle the menu's up and down by incrementing or decrementing the menu position.
			//	User can also enter a submenu by activating it, or exiting my activating exit.
			switch(m_nSelection)
			{
			case 0:
				{
					CGame::GetInstance()->RemoveState();
					CGame::GetInstance()->AddState(CGamePlayState::GetInstance());
				}
				break;
			case 1:
				{
					CGame::GetInstance()->AddState(COptionsState::GetInstance());
				}
				break;

			case 2:
				{

				}
				break;
			case 3:
				{
					CGame::GetInstance()->RemoveState();
					return false;
				}
				break;
			}
		}

		if(pDI->GetBufferedKey(DIK_DOWNARROW))
		{
			if(m_fCursorYPos == 350.0f)
				m_fCursorYPos = 125.0f;
			else
				m_fCursorYPos += 75.0f;
		}
		else if(pDI->GetBufferedKey(DIK_UPARROW))
		{
			if(m_fCursorYPos == 125.0f)
				m_fCursorYPos = 350.0f;
			else
				m_fCursorYPos -= 75.0f;
		}
		
		

	return true;
}

//////////////////////////////////////////
// Function: "Update"
// Purpose:  Updates the class based on time
//////////////////////////////////////////
void CMainMenuState::Update(float fElapsedTime)
{
	// Process events for the main menu
	m_pES->ProcessEvents();

	m_fDelayTime+= fElapsedTime;
}

//////////////////////////////////////////
// Function: "Render"
// Purpose:  Draws the options menu
//////////////////////////////////////////
void CMainMenuState::Render(void)
{
	static CSGD_Direct3D* pD3D = CSGD_Direct3D::GetInstance();

	if(m_fDelayTime < 0.2f)
	{
		m_pTM->DrawTexture(staticImageID1, 0, 0);
	}
	else
		if(m_fDelayTime < 0.4f)
		{
			m_pTM->DrawTexture(staticImageID2, 0, 0);
		}
		else
			if(m_fDelayTime < 0.6f)
			{
				m_pTM->DrawTexture(staticImageID3, 0, 0);
			}
			else
				if(m_fDelayTime < 0.8f)
				{
					m_pTM->DrawTexture(staticImageID4, 0, 0);
				}
				else
					m_fDelayTime = 0.0f;

	m_pTM->DrawTexture(m_nCursorID, 75.0f, m_fCursorYPos, 0.5f, .75f, .75f);

	// Play
	m_pTM->DrawTexture(m_nPlayID, 125, 125, 0.5f, 0.75f, 0.75f); 

	// Options
	m_pTM->DrawTexture(m_nOptionsID, 75, 200, 0.5f, 0.75f, 0.75f); 

	// Load
	m_pTM->DrawTexture(m_nLoadID, 125, 275, 0.5f, 0.75f, 0.75f); 

	// Exit
	m_pTM->DrawTexture(m_nExitID, 115, 325, 0.5f, 0.75f, 0.75f); 
}

//////////////////////////////////////////
// Function: "HandleEvent"
// Purpose:  Handles any events concerning
//			 the options menu
//////////////////////////////////////////
void CMainMenuState::HandleEvent(CEvent* pEvent)
{

}

//////////////////////////////////////////
// Function: "MessageProc"
// Purpose:  Processes messages for the options menu
//////////////////////////////////////////
void CMainMenuState::MessageProc(CBaseMessage* pMsg)
{
}
